<?php

defined('EM_ROOT') || exit('access denied!');
require_once View::getView('module');

$version = '1720327727';

$q = Input::getStrVar('q');

?>
<!doctype html>
<html lang="zh-cn" data-theme="light">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?= $site_title ?></title>
    <meta name="keywords" content="<?= $site_key ?>"/>
    <meta name="description" content="<?= $site_description ?>"/>
    <link href="<?= empty(_g('favicon')) ? EM_URL . 'favicon.ico' : _g('favicon'); ?>" rel="icon">
    <link rel="alternate" title="RSS" href="<?= EM_URL ?>rss.php" type="application/rss+xml"/>

    <link rel="stylesheet" href="../../../admin/views/css/bootstrap.min.css">

    <script src="../../../admin/views/js/jquery.min.3.5.1.js"></script>
    <script src="../../../admin/views/js/bootstrap.bundle.min.4.6.js?t=<?= Option::EM_VERSION_TIMESTAMP ?>"></script>
    <!-- 字体 -->
    <link rel="stylesheet" type="text/css" href="../../../admin/views/font-awesome-4.7.0/css/font-awesome.min.css">


    <link rel="stylesheet" href="../../../admin/views/layui-v2.11.6/layui/css/layui.css">
    <script src="../../../admin/views/layui-v2.11.6/layui/layui.js"></script>
    <link href="<?= TEMPLATE_URL ?>css/style.css?v=<?= time() ?>" rel="stylesheet"/>


    <script src="<?= TEMPLATE_URL ?>js/zoom.js?v=<?= $version ?>&t=<?= Option::EM_VERSION_TIMESTAMP ?>"></script>


    <link rel="stylesheet" href="../../content/common/css/home.css">


    <style>
        body{
            background: #f7f7f7;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            word-break: break-all;
        }
        .container{
            flex-grow: 1;
            padding-left: 15px;
            padding-right: 15px;
        }
        .navbar-default{
            background: #fff;
            height: 50px;
        }

        .navbar-brand{
            height: 50px;
            padding: 12px 15px 14px 0;
        }

        @media (min-width: 992px){
            .navbar-nav>li>a{
                padding-top: 14px;
                padding-bottom: 14px;
            }
        }



        /* 商品列表的样式 */


        /* 卡片样式 - 白色背景 + 阴影 + 圆角 */
        .card {
            background: #fff;
            border: unset;
            border-radius: 4px !important;
            overflow: hidden;
            text-decoration: none;
            color: #333;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05)!important;
            transition: box-shadow 0.3s;

        }

        .card:hover {
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.25);
            text-decoration: none;
        }

        /* 图片容器 - 新增 */
        .goods-img-container {
            width: 100%;
            aspect-ratio: 1 / 1;
            overflow: hidden; /* 关键：确保图片放大不超出 */
            position: relative;
            background: #f5f5f5;
        }

        /* 封面图（保持正方形） */
        .goods-cover {
            width: 100%;
            height: 100%;
            object-fit: cover;
            object-position: center;
            transition: transform 0.3s ease;
            transform-origin: center center; /* 从中心点放大 */
            aspect-ratio: 1 / 1;
        }



        /* 文字内容区域 */


        .card-content, .card-actions {
            padding: 0 8px 3px !important;
        }

        /* 价格样式 */
        .text-danger {
            color: #ff4d4f !important;
        }
        .market-price {
            color: #999;
            margin-left: 5px;
        }

        .mobile-search-order-btn {
            display: none;
            height: 38px;
            text-align: center;
            text-decoration: none;
            text-transform: uppercase;
            font-size: 16px;
            color: #fff;
            border-radius: 5px;
            background-image: linear-gradient(to right, #03a9f4, #f441a5, #ffeb3b, #09a8f4);
            padding: 6px 20px;
            background-size: 400%;
            line-height: 28px;
            margin-right: 3px;
        }

        @media (max-width: 850px) {
            .mobile-search-order-btn {
                display: block;
            }
        }

        iframe{
            max-width: 100%!important;
        }

    </style>


    <?php doAction('index_head') ?>
    <script>
        // 日历生成和翻页
        function sendinfo(url) {
            $("#calendar").load(url)
        }

        // 切换夜间模式主题
        const savedTheme = localStorage.getItem('theme');
        if (savedTheme) {
            document.documentElement.setAttribute('data-theme', savedTheme);
        }
    </script>

    <?php if(Option::get('login_switch') == 'n' || Option::get('register_switch') == 'n'): ?>
    <style>
        .m-btn {
            right: 50px;
        }
    </style>
    <?php endif; ?>
</head>
<body>

<div id="mask"></div>
<header class="header">
    <div class="h-fix">
        <div class="container">
            <h1 class="logo">
                <a href="<?= EM_URL ?>" title="">
                    <?php if(empty(Option::get('logo'))): ?>
                        <span class="placeholder"><?= $blogname ?></span>
                        <span id="light-logo"><?= $blogname ?></span>
                    <?php else: ?>
                        <style>
                            .header .logo a img{
                                min-width: 200px;
                            }
                            .header .logo a .placeholder{
                                min-width: 200px;
                            }
                        </style>
                        <span class="placeholder"></span>
                        <img id="light-logo" src="<?= Option::get('logo') ?>" alt="<?= $blogname ?>" title="<?= $blogname ?>">
                    <?php endif; ?>



                </a>
            </h1>
            <div id="m-btn" class="m-btn"><i class="fa fa-bars"></i></div>

            <div class="search"> <i class="s-btn off fa fa-search"></i>
                <div class="s-form"> <i class="arrow fa fa-caret-up"></i>
                    <form name="formsearch" action="" class="sform">
                        <input class="sinput" name="q" type="text" placeholder="请输入搜索词" value="<?= $q ?>">
                        <button><i class="fa fa-search"></i></button>
                    </form>
                </div>
            </div>
            <?php if(Option::get('login_switch') == 'y' && Option::get('register_switch') == 'y'): ?>
            <div class="search">
                <a href="<?= EM_URL ?>user/balance.php" class="">
                    <i class="fa fa-user"></i>
                </a>
            </div>
            <?php endif; ?>
            <nav class="nav-bar" id="nav-box" data-type="index" data-infoid="">
                <ul class="nav"><?php blog_navi() ?></ul>
            </nav>
            <div class="submit fr">
                <a href="<?= EM_URL ?>user/visitors.php" class="a transition">
                    <i class="fa fa-heart"></i>查询订单
                </a>
            </div>

        </div>
    </div>
</header>
