<?php
defined('EM_ROOT') || exit('access denied!');



function plugin_setting_view() {
    $tpl = TplOptions::getInstance();
    $data = $tpl->getTemplateOptions('default');
//    d($data);die;
    $data['favicon'] = empty($data['favicon']) ? '' : $data['favicon'];
    $data['category_show'] = empty($data['category_show']) ? 'n' : $data['category_show'];
    ?>
    <style>
        #form-btn{
            background: #eee;
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            height: 50px;
            line-height: 50px;
            margin: 0 auto;
            text-align: center;
        }



    </style>
    <form class="layui-form" id="form" method="post" action="?tpl=default&action=setting_ajax">
        <div style="padding: 25px;" id="open-box">
            <!-- 基本信息设置 -->
            <div class="form-section">

                <div class="layui-form-item">
                    <label class="layui-form-label">浏览器图标</label>
                    <div class="layui-input-block">
                        <div class="layui-input-group" style="width: 100%; display: flex;">
                            <input type="text" value="<?= $data['favicon'] ?>" placeholder="" class="layui-input" name="favicon" id="sortimg">
                            <div id="ID-upload-demo-btn" class="layui-input-split layui-input-suffix layui-btn" style="display: table-cell; line-height: 192%;">
                                上传图片
                            </div>
                        </div>
                    </div>
                </div>

                <div class="layui-form-item">
                    <label class="layui-form-label" for="password">显示分类模块</label>
                    <div class="layui-input-block">
                        <input type="checkbox" <?= $data['category_show'] == 'y' ? 'checked' : '' ?> name="category_show" lay-skin="switch" value="y" title=" ON |OFF " >
                    </div>
                </div>



            </div>

        </div>

        <div style="width: 100%; height: 50px;"></div>
        <div class="" id="form-btn">
            <div class="layui-input-block" style="margin: 0 auto;">
                <button type="submit" class="layui-btn" lay-submit lay-filter="submit">保存配置</button>
                <button type="reset" class="layui-btn layui-btn-primary">重置</button>
            </div>
        </div>
    </form>
    <script>

        layui.use(['table'], function(){
            var $ = layui.$;
            var form = layui.form;
            var upload = layui.upload;
            var element = layui.element;
            form.on('submit(submit)', function(data){
                var field = data.field; // 获取表单全部字段值
                var url = $('#form').attr('action');
                $.ajax({
                    type: "POST",
                    url: url,
                    data: field,
                    dataType: "json",
                    success: function (e) {
                        parent.layer.close('setting')
                        parent.layer.msg('已保存配置');
                        window.parent.table.reload();
                    },
                    error: function (xhr) {
                        layer.msg(JSON.parse(xhr.responseText).msg);
                    }
                });
                return false; // 阻止默认 form 跳转
            });



            var uploadInst = upload.render({
                elem: '#ID-upload-demo-btn',
                field: 'image',
                url: './article.php?action=upload_cover', // 实际使用时改成您自己的上传接口即可。
                before: function(obj){
                    // 预读本地文件示例，不支持ie8
                    obj.preview(function(index, file, result){
                        $('#ID-upload-demo-img').attr('src', result); // 图片链接（base64）
                    });

                    element.progress('filter-demo', '0%'); // 进度条复位
                    loadIndex = layer.load(2);
                },
                done: function(res){
                    // 若上传失败
                    if(res.code > 0){
                        return layer.msg('上传失败');
                    }
                    // 上传成功的一些操作
                    if(res.code == 0){
                        $('#sortimg').val(res.data)
                    }
                    $('#ID-upload-demo-text').html(''); // 置空上传失败的状态
                },
                error: function(){
                    // 演示失败状态，并实现重传
                    var demoText = $('#ID-upload-demo-text');
                    demoText.html('<span style="color: #FF5722;">上传失败</span> <a class="layui-btn layui-btn-xs demo-reload">重试</a>');
                    demoText.find('.demo-reload').on('click', function(){
                        uploadInst.upload();
                    });
                },
                // 进度条
                progress: function(n, elem, e){
                    element.progress('filter-demo', n + '%'); // 可配合 layui 进度条元素使用
                    if(n == 100){
                        layer.close(loadIndex)
                    }
                }
            });



        })











        var maxHeight = $(window.parent).innerHeight() * 0.75;



        // 2. 为 #open-box 设置 max-height，同时添加溢出滚动
        $("#open-box").css({
            "max-height": maxHeight + "px", // 单位必须加 px
            "overflow-y": "auto" // 内容超过 max-height 时显示垂直滚动条
        });

    </script>
<?php }

function plugin_setting($tpl) {
    $favicon = Input::postStrVar('favicon');
    $category_show = Input::postStrVar('category_show', 'n');
    $tplOptions = TplOptions::getInstance();


    $data = [
        [
            'template' => $tpl,
            'name'     => 'favicon',
            'depend'   => '',
            'data'     => serialize($favicon),
        ], [
            'template' => $tpl,
            'name'     => 'category_show',
            'depend'   => '',
            'data'     => serialize($category_show),
        ],
    ];

    $tplOptions->insert('data', $data, true);

    Output::ok();
}