<?php defined('EM_ROOT') || exit('access denied!'); ?>
<div class="layui-btn-container">
    <a href="./store.php" class="layui-btn layui-bg-blue">全部应用</a>
    <a href="./store.php?action=tpl" class="layui-btn layui-btn-primary layui-border-blue">模板主题</a>
    <button class="layui-btn layui-btn-primary layui-border-blue plugin-category">
        <span>扩展插件</span>
        <i class="layui-icon layui-icon-down layui-font-12"></i>
    </button>
</div>
<table class="layui-hide" id="index" lay-filter="index"></table>

<script type="text/html" id="toolbar">
    <div class="layui-btn-container">
        <button class="layui-btn layui-btn-sm" lay-event="refresh">
            刷新
        </button>
    </div>
</script>
<script type="text/html" id="vip">
    <div class="layui-clear-space">
        {{#  if(d.vip_price == 0){ }}
        <span class="badge badge-rim-green">免费</span>
        {{#  } }}
        {{#  if(d.vip_price != 0){ }}
        <span class="badge badge-rim-red">&yen;<span style="margin-left: 3px;">{{ d.vip_price }}</span></span>
        {{#  } }}
    </div>
</script>
<script type="text/html" id="svip">
    <div class="layui-clear-space">
        {{#  if(d.svip_price == 0){ }}
        <span class="badge badge-rim-green">免费</span>
        {{#  } }}
        {{#  if(d.svip_price != 0){ }}
        <span class="badge badge-rim-red">&yen;<span style="margin-left: 3px;">{{ d.svip_price }}</span></span>
        {{#  } }}
    </div>
</script>

<script type="text/html" id="cover">
    <div class="layui-clear-space">
        <a href="javascript:;" data-id="{{ d.id }}" lay-event="img">
            <img onerror="this.onerror=null; this.src='./views/images/null.png'" class="cover" data-img="{{ d.img }}" src="{{ d.img }}" style="width: 50px; border-radius: 3px;" />
        </a>
    </div>
</script>

<script type="text/html" id="name">
    <div class="layui-clear-space">
        <div><strong>{{ d.name }}</strong></div>
        <div>{{ d.description }}</div>
    </div>
</script>
<script type="text/html" id="operate">
    <div class="layui-clear-space">
<!--        $type = $v['type'] === 'template' ? 'tpl' : 'plugin';-->
<!--        $order_url = SERVICE_HOST . '/index/order/submit/' . $type . '/' . $v['id'];-->

        {{#  if(d.is_install == 'y'){ }}
        <button class="layui-btn layui-border-green layui-btn-primary">已安装</button>
        {{#  } }}
        {{#  if(d.is_install == 'n' && d.reg_type == '0' && d.vip_price > 0){ }}
        <button class="layui-btn layui-btn-primary layui-border-blue" lay-event="auth">限授权用户安装</button>
        {{#  } }}
        {{#  if(d.pay == 'y' && d.is_install == 'n'){ }}
        <button class="layui-btn" lay-event="install">已购买，立即安装</button>
        {{#  } }}
        {{#  if(d.pay == 'n' && d.is_install == 'n' && d.reg_type == '1' && d.vip_price > 0){ }}
        <a target="_blank" href="<?= SERVICE_HOST ?>/index/order/submit/emkey/<?= $emkey ?>/{{ d.type == 'template' ? 'tpl' : 'plugin' }}/{{ d.id }}" class="layui-btn layui-bg-blue">立即购买</a>
        {{#  } }}
        {{#  if(d.pay == 'n' && d.is_install == 'n' && d.reg_type == '2' && d.svip_price > 0){ }}
        <a target="_blank" href="<?= SERVICE_HOST ?>/index/order/submit/emkey/<?= $emkey ?>/{{ d.type == 'template' ? 'tpl' : 'plugin' }}/{{ d.id }}" class="layui-btn layui-bg-blue">立即购买</a>
        {{#  } }}
        {{#  if(d.is_install == 'n' && d.reg_type == '0' && d.vip_price == 0){ }}
        <button class="layui-btn" lay-event="install">免费安装</button>
        {{#  } }}
        {{#  if(d.is_install == 'n' && d.reg_type == '1' && d.vip_price == 0){ }}
        <button class="layui-btn" lay-event="install">免费安装</button>
        {{#  } }}
        {{#  if(d.is_install == 'n' && d.reg_type == '2' && d.svip_price == 0){ }}
        <button class="layui-btn" lay-event="install">免费安装</button>
        {{#  } }}

    </div>
</script>


<script>
    layui.use(['table'], function(){
        var table = layui.table;
        var form = layui.form;

        var dropdown = layui.dropdown;
        // 渲染
        dropdown.render({
            elem: '.plugin-category', // 绑定元素选择器，此处指向 class 可同时绑定多个元素
            data: <?= json_encode($plugin_type_arr) ?>,
            click: function(obj){
                location.href="./store.php?action=plu&plugin_type=" + obj.id + "&title=" + obj.title;

            }
        });

        // 创建渲染实例
        window.table = table.render({
            elem: '#index',
            autoSort: false,
            url: '?action=index', // 此处为静态模拟数据，实际使用时需换成真实接口
            toolbar: '#toolbar',
            limits: [10,20,30,50,100],
            lineStyle: 'height: 69px;',
            page: true,
            defaultToolbar: ['filter', 'exports', 'print', { // 右上角工具图标
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips',
                onClick: function(obj) { // 2.9.12+
                    layer.alert('自定义工具栏图标按钮');
                }
            }],


            cols: [[
                {field:'preview', title:'演示图', width: 80, templet: '#cover', align: 'center'},
                {field:'name', title:'插件名/描述', minWidth: 490, templet: '#name'},
                {field:'svip_price', title:'SVIP价格', minWidth: 100, align: 'center', templet: '#svip'},
                {field:'vip_price', title:'普通会员', minWidth: 100, align: 'center', templet: '#vip'},
                {field:'version', title:'插件版本', minWidth: 120, align: 'center'},
                {title:'操作', templet: '#operate', width: 185}
            ]],

            error: function(res, msg){
                console.log(res, msg)
            }
        });

        // 搜索提交
        form.on('submit(index-search)', function(data){
            var field = data.field; // 获得表单字段
            // 执行搜索重载
            table.reload('index', {
                page: {
                    curr: 1 // 重新从第 1 页开始
                },
                where: field // 搜索的字段
            });
            return false; // 阻止默认 form 跳转
        });


        // 工具栏事件
        table.on('toolbar(index)', function(obj){
            var id = obj.config.id;
            var checkStatus = table.checkStatus(id);
            var othis = lay(this);
            switch(obj.event){
                case 'refresh':
                    table.reload(id);
                    break;
            };
        });

        // 触发单元格工具事件
        table.on('tool(index)', function(obj){ // 双击 toolDouble
            var data = obj.data; // 获得当前行数据
            var id = obj.config.id;
            if(obj.event == 'auth'){
                layer.confirm('是否前往授权页面？', {
                    btn: ['立即前往', '取消'], // 按钮
                    icon: 3,             // 图标，3表示问号
                    title: '温馨提示'
                }, function(index) {
                    layer.closeAll()
                    location.href="./auth.php"
                });
            }
            if(obj.event === 'install'){
                var loadIndex = layer.load(2);
                layer.msg('正在安装，请稍后');

                var type = data.type == 'template' ? 'tpl' : 'plugin';
                $.ajax({
                    url: './store.php?action=install',
                    type: 'POST',
                    dataType: 'json',
                    data: { type: type, source: data.download_url, cdn_source: data.cdn_download_url },
                    success: function(e) {

                        layer.close(loadIndex)
                        if(e.code == 400){
                            return layer.msg(e.msg)
                        }
                        layer.msg('安装成功');
                        table.reload(id);
                    },
                    error: function(err) {
                        layer.close(loadIndex)
                        layer.alert(err.responseJSON.msg);
                    }
                });
            }

            if(obj.event === 'img'){
                layer.photos({
                    photos: {
                        "title": data.name,
                        "start": 0,
                        "data": [
                            {
                                "alt": data.name,
                                "pid": 1,
                                "src": data.img,
                            }
                        ]
                    }
                });
            }
        });

        // 触发排序事件
        table.on('sort(index)', function(obj){
            console.log(obj.field); // 当前排序的字段名
            console.log(obj.type); // 当前排序类型：desc（降序）、asc（升序）、null（空对象，默认排序）
            console.log(this); // 当前排序的 th 对象

            // 尽管我们的 table 自带排序功能，但并没有请求服务端。
            // 有些时候，你可能需要根据当前排序的字段，重新向后端发送请求，从而实现服务端排序，如：
            table.reload('index', {
                initSort: obj, // 记录初始排序，如果不设的话，将无法标记表头的排序状态。
                where: { // 请求参数（注意：这里面的参数可任意定义，并非下面固定的格式）
                    field: obj.field, // 排序字段
                    order: obj.type // 排序方式
                }
            });
        });

        // 触发表格复选框选择
        table.on('checkbox(index)', function(obj){
            var id = obj.config.id;
            var checkData = table.checkStatus(id).data;
            console.log(checkData)
            if(checkData.length == 0){
                $('#toolbar-del').addClass('layui-btn-disabled');
            }else{
                $('#toolbar-del').removeClass('layui-btn-disabled');
            }
        });

        // 分页栏事件
        table.on('pagebar(index)', function(obj){
            alert()
            console.log(obj); // 查看对象所有成员
            console.log(obj.config); // 当前实例的配置信息
            console.log(obj.event); // 属性 lay-event 对应的值
        });


        // 表头自定义元素工具事件 --- 2.8.8+
        table.on('colTool(test)', function(obj){
            var event = obj.event;
            console.log(obj);
            if(event === 'email-tips'){
                layer.alert(layui.util.escape(JSON.stringify(obj.col)), {
                    title: '当前列属性选项'
                });
            }
        });




    });




</script>





<script>
    $(function () {
        $("#menu-store").addClass('active');
        setTimeout(hideActived, 3600);

        $('.category').on('change', function () {
            var selectedCategory = $(this).val();
            if (selectedCategory) {
                window.location.href = './store.php?sid=' + selectedCategory;
            }
        });
    });
</script>
