<?php
/**
 *
 */
defined('EM_ROOT') || exit('access denied!');

$payment = getPayment();
?>

<style>
    .goods-sku .label{
        font-size: 13px;
        padding: 6px 12px;
        margin-right: 5px;
        cursor: pointer;
        color: #5c5c5c;
        border-color: #F0F0F0;
        background: #F0F0F0;
        white-space: nowrap;
        margin-bottom: 12px;
        display: inline-block;
    }
    .goods-sku .label:hover{
        background: #E0E0E0;
    }

    .goods-attr .currency, .goods-attr .price{
        color: #ea644a;
        font-size: 14px;
    }

    .goods-attr .price{
        font-size: 28px;
    }

    .goods-attr .bh-sku-selected{
        color: #ea644a;
        border-color: #ea644a;
        background: #FFF7F3;
    }
    .goods-attr .bh-sku-selected:hover{
        color: #ea644a;
        border-color: #ea644a;
        background: #FFF7F3;
    }
    .goods-con .panel{
        border: none;
    }

    .label[disabled="disabled"]{
        background: #F0F0F0;
        opacity: 0.5; /* 降低透明度 */
    }
    .label[disabled="disabled"]:hover{
        background: #F0F0F0;
        opacity: 0.5; /* 降低透明度 */
        cursor: not-allowed; /* 改变鼠标光标样式 */
    }

    /*数量选择器 start*/
    /* 数量选择器整体样式 */
    .quantity-selector {
        display: inline-flex;
        align-items: center;
        gap: 8px; /* 标签和选择器间距 */
        margin: 10px 0;
    }

    /* 数量标签样式 */
    .quantity-label {
        font-size: 14px;
        color: #666;
        position: relative;
        top: -1px; /* 微调垂直对齐 */
    }

    /* 数量选择器容器 */
    .spinner {
        display: inline-flex;
        align-items: center;
        border: 1px solid #ddd;
        border-radius: 4px;
        overflow: hidden;
        background: #fff;
        box-shadow: 0 1px 2px rgba(0,0,0,0.05);
        height: 32px; /* 固定高度 */
    }

    /* 加减按钮通用样式 */
    .spinner .btn {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 32px;
        height: 100%;
        background: #f8f8f8;
        color: #666;
        font-size: 16px;
        font-weight: bold;
        cursor: pointer;
        user-select: none;
        transition: all 0.2s;
        border: none;
        outline: none;
    }

    /* 减号按钮 */
    .spinner .decrease {
        border-right: 1px solid #eee;
    }

    /* 加号按钮 */
    .spinner .increase {
        border-left: 1px solid #eee;
    }

    /* 按钮悬停效果 */
    .spinner .btn:hover {
        background: #eaeaea;
        color: #333;
    }

    /* 按钮点击效果 */
    .spinner .btn:active {
        background: #ddd;
    }

    /* 输入框样式 */
    .spinner .value {
        width: 40px;
        height: 100%;
        border: none;
        text-align: center;
        font-size: 14px;
        color: #333;
        padding: 0 5px;
        outline: none;
        -moz-appearance: textfield; /* 隐藏数字输入框的上下箭头 */
    }

    /* 隐藏数字输入框的上下箭头（Chrome/Safari） */
    .spinner .value::-webkit-outer-spin-button,
    .spinner .value::-webkit-inner-spin-button {
        -webkit-appearance: none;
        margin: 0;
    }

    /* 输入框聚焦效果 */
    .spinner .value:focus {
        background: #f5f5f5;
    }
    /*数量选择器 end*/

    /* 售罄提示容器 start */
    /* 终极简约售罄提示 */
    .soldout-notice {
        padding: 18px;
        margin: 24px 0;
        background: #fafafa;
        border-left: 3px solid #e0e0e0;
        font-size: 15px;
        color: #555;
        display: flex;
        align-items: center;
        line-height: 1.5;
        position: relative;
    }

    /* 更克制的图标 */
    .soldout-icon {
        margin-right: 14px;
        color: #777;
        font-size: 20px;
        font-weight: 300;
    }

    /* 精致文字链接 */
    .soldout-link {
        color: #222;
        text-decoration: none;
        border-bottom: 1px solid #ccc;
        padding-bottom: 1px;
        margin-left: 6px;
        transition: all 0.2s ease;
    }

    .soldout-link:hover {
        text-decoration: none;
    }

    /* 极简动画 */
    .soldout-notice {
        transition: all 0.3s ease;
    }

    .soldout-notice:hover {
        background: #f5f5f5;
    }
    /*售罄提示容器 end*/

    .intro{
        overflow-wrap: break-word; /* 允许非单词边界的换行 */
        word-wrap: break-word;     /* 兼容旧版浏览器 */
        word-break: break-all; /* 强制在任意字符处换行 */
    }
    .intro img{
        max-width: 100%;
        height: auto;
    }
    .intro a {
        color: #007bff;
        text-decoration: none;
        background-color: transparent;
    }
    .intro a:hover {
        text-decoration: underline;
    }
    .goods-cover {
        height: 200px;
        display: block;
        width: 200px;
        margin: 0 auto;
    }
    .card-title{
        font-size: 1.1rem;
        font-weight: 500;
    }

    .drawer-content {
        /*max-height: 50vh;*/
        /*overflow-y: auto;*/
        /*padding: 15px;*/
    }
    .drawer-footer {
        padding: 10px 15px;
        box-shadow: 3px 3px 6px rgba(0, 0, 0, 0.4);
        border-radius: 10px;
    }
    .drawer-total {
        display: flex;
        justify-content: space-between;
        margin-bottom: 15px;
        font-size: 15px;
    }
    .buy-btn-g {
        background-color: rgb(22 93 255 / 90%);
        color: #fff;
    }
    .action-btn {
        flex: 1;
        border: none;
        color: #fff;
        font-size: 16px;
        cursor: pointer;
        font-weight: 500;
    }
    .total-price {
        font-weight: normal;
        font-size: 16px;
        color: #fff;
        margin-left: 5px;
    }
    .drawer-actions {
        display: flex;
        gap: 10px;
    }
    .drawer-btn {
        flex: 1;
        padding: 6px 0;
        border-radius: 8px;
        border: none;
        font-size: 14px;
        font-weight: 500;
        cursor: pointer;
    }
    .mask {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: rgba(0,0,0,0.5);
        z-index: 1005;
        opacity: 0;
        pointer-events: none;
        transition: opacity 0.3s ease;
    }
    .mask.open {
        opacity: 1;
        pointer-events: auto;
    }

    /* 规格选择样式 */
    .spec-group {
        margin-bottom: 15px;
    }
    .spec-title {
        font-size: 15px;
        color: #333;
        margin-bottom: 2px;
        align-items: center;
    }
    .spec-title i {
        margin-right: 6px;
        color: #999;
    }
    .spec-options {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
    }
    .spec-option {
        padding: 8px 15px;
        border: 1px solid #ddd;
        border-radius: 6px;
        font-size: 13px;
        cursor: pointer;
        transition: all 0.2s;
        background-color: #fff;
    }
    .spec-option.active {
        border-color: #165DFF;
        color: #165DFF;
        background-color: #007bff14;
        position: relative;
    }
    .spec-option.active::after {
        content: "✓";
        position: absolute;
        right: 5px;
        bottom: 0;
        font-size: 12px;
        font-weight: bold;
    }
    .spec-option.disabled {
        color: #ccc;
        border-color: #eee;
        background-color: #f9f9f9;
        cursor: not-allowed;
    }

    /* 数量选择器 */
    .quantity-selector {
        display: flex;
        align-items: center;
        margin-top: 5px;
    }
    .quantity-btn {
        width: 34px;
        height: 34px;
        border: 1px solid #ddd;
        border-radius: 6px;
        background-color: #fff;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        font-size: 18px;
    }
    .quantity-input {
        width: 45px;
        height: 34px;
        border: 1px solid #ddd;
        border-bottom: 1px solid #ddd;
        text-align: center;
        margin: 0 -1px;
        font-size: 16px;
    }

    .footer-nav{
        display: none;
    }


    .payment-methods {
        display: flex;
        flex-wrap: wrap;
        gap: 10px; /* 两个选项之间的间距 */
        flex-direction: unset;
    }
    .payment-item {
        width: calc(50% - 5px); /* 计算宽度，确保两列显示 */
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.2s;
        display: flex;
        align-items: center;
        box-sizing: border-box;
        background-color: #fff;
    }
    .payment-item:hover {
        border-color: #1E9FFF;
    }
    .payment-item.active {
        border-color: #1E9FFF;
        background-color: rgba(30, 159, 255, 0.05);
    }
    .payment-icon {
        width: 36px;
        height: 36px;
        margin-right: 10px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        background-color: #f5f5f5;
    }
    .payment-icon img {
        width: 24px;
        height: 24px;
    }
    .payment-info {
        flex: 1;
        min-width: 0; /* 解决文本溢出问题 */
    }
    .payment-name {
        font-size: 15px;
        color: #333;
        margin-bottom: 2px;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    .payment-desc {
        font-size: 11px;
        color: #999;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    .payment-checked {
        color: #1E9FFF;
        font-size: 20px;
        display: none;
    }
    .payment-item.active .payment-checked {
        display: block;
    }
    .amount-bar {
        padding: 15px;
        background-color: #fff;
        margin-top: 10px;
        font-size: 16px;
    }
    .amount-bar span {
        color: #ff4d4f;
        font-size: 18px;
        font-weight: bold;
    }
    .confirm-btn {
        padding: 15px;
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;
        background-color: #fff;
        box-shadow: 0 -2px 10px rgba(0,0,0,0.05);
        box-sizing: border-box;
    }
    .confirm-btn button {
        width: 100%;
        height: 45px;
        font-size: 16px;
    }
    .cancel-btn {
        margin-bottom: 10px;
    }

    /* 适配小屏手机 */
    @media (max-width: 320px) {
        .payment-name {
            font-size: 14px;
        }
        .payment-icon {
            width: 32px;
            height: 32px;
        }
        .payment-icon img {
            width: 20px;
            height: 20px;
        }
    }


    /* 内部文本保持普通样式（不做额外美化） */
    .service-content {
        padding: 15px 18px;
        line-height: 1.8;
        color: #333;
    }

    .content-title {
        font-size: 22px;
        font-weight: bold;
        margin-bottom: 20px;
        border-bottom: 1px solid #eee;
        padding-bottom: 10px;
    }

    .content-section {
        margin-bottom: 20px;
    }

    .section-title {
        font-size: 16px;
        font-weight: bold;
        margin: 15px 0 10px;
    }

    .content-text {
        margin-bottom: 10px;
        text-indent: 2em;
    }

    .content-list {
        padding-left: 2em;
    }

    .content-list li {
        margin-bottom: 8px;
        list-style-type: disc;
    }

    /* 弹窗核心美化（重点优化部分） */
    .layui-layer {
        border-radius: 12px !important; /* 更大更柔和的圆角 */
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.12) !important; /* 更有层次感的阴影 */
        overflow: hidden !important;
        border: none !important; /* 去掉默认边框 */
    }

    /* 标题栏美化 */
    .layui-layer-title {
        background: linear-gradient(90deg, #1E9FFF, #0086E6) !important;
        color: white !important;
        font-size: 18px !important;
        padding: 15px 20px !important;
        border-bottom: none !important;
        position: relative;
        line-height: 20px;
    }

    /* 关闭按钮美化 */
    .layui-layer-setwin .layui-layer-close1 {
        width: 30px !important;
        height: 30px !important;
        background-position: -120px -30px !important;
        top: 1px !important;
        right: 4px !important;
        transition: all 0.2s !important;
        color: #fff;
    }

    .layui-layer-setwin .layui-layer-close1:hover {
        transform: rotate(90deg) !important;
        background-position: -150px -30px !important;
    }
    .layui-form-pane .layui-input-block{
        margin-left: 0;
    }

</style>

<article class="container goods-con" style="margin-top: 15px;">

    <div class="card mb-3" style="">
        <div class="row no-gutters">
            <div class="col-md-4" style="padding: 10px;">
                <img class="goods-cover" src="<?= $goods['cover'] ?>" alt="" style="" />
            </div>
            <div class="col-md-8" style="padding-bottom: 1rem;">
                <div class="card-body goods-attr">
                    <h3 class="card-title"><?= $goods['title'] ?></h3>
                    <p class="card-text">
                        <?php if(Option::get('sales_switch') == 'y'): ?>
                            <span class="text-muted">已售：<?= $goods['sales'] ?></>
                        <?php endif; ?>
                        <?php if(Option::get('stock_switch') == 'y'): ?>
                            <span class="text-muted ml-3">库存：<span id="stock"><?= $goods['stock'] ?></span></span>
                        <?php endif; ?>
                    </p>
                    <div style="margin-bottom: 15px;">
                        <span class="currency">¥</span>
                        <span class="price" id="price"><?= $goods['price'] ?></span>
                    </div>

                    <div class="col-lg-12" style="padding: 0;">

                        <div class="drawer-content">
                            <?php foreach($goods['spec'] as $val): ?>
                                <div class="spec-group">
                                    <div class="spec-title">
                                        <?= $val['title'] ?>
                                    </div>
                                    <div class="spec-options">
                                        <?php foreach($val['sku_values'] as $v): ?>
                                            <div class="spec-option" data-id="<?= $v['id'] ?>"><?= $v['name'] ?></div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                            <div class="spec-group">
                                <div class="spec-title">
                                    <i class="fa fa-calculator"></i>购买数量
                                </div>
                                <div class="quantity-selector">
                                    <div class="quantity-btn minus" id="drawerMinusBtn"><i class="fa fa-minus"></i></div>
                                    <input type="number" class="quantity-input" id="drawerQuantityInput" value="1" min="1">
                                    <div class="quantity-btn plus" id="drawerPlusBtn"><i class="fa fa-plus"></i></div>
                                </div>
                            </div>

                            <?php foreach($goods['attach_user'] as $key => $val): ?>
                                <div class="spec-group">
                                    <div class="spec-title"><?= $key ?></div>
                                    <div class="layui-form-item">
                                        <div class="layui-input-block">
                                            <input type="text" name="attach[<?= $key ?>]" placeholder="<?= $val ?>" autocomplete="off" class="layui-input attach-input">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                            <?php foreach($order_required as $val): ?>
                                <div class="spec-group">
                                    <div class="spec-title"><?= $val['name'] ?></div>
                                    <div class="layui-form-item">
                                        <div class="layui-input-block">
                                            <input type="text" name="required[<?= $val['name'] ?>]" placeholder="<?= $val['placeholder'] ?>" autocomplete="off" class="layui-input required-input">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                            <div class="spec-group">
                                <div class="spec-title">
                                    <i class="fa fa-credit-card"></i>选择支付方式
                                </div>
                                <div class="payment-methods">
                                    <?php foreach($payment as $val): ?>
                                        <div class="payment-item" data-method="<?= $val['plugin_name'] ?>">
                                            <div class="payment-icon">
                                                <img src="<?= $val['icon'] ?>" alt="<?= $val['name'] ?>">
                                            </div>
                                            <div class="payment-info">
                                                <div class="payment-name"><?= $val['name'] ?></div>
                                            </div>
                                            <div class="payment-checked layui-icon layui-icon-ok-circle"></div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                        <div class="drawer-footer">
                            <div class="drawer-actions">
            <span style="line-height: 40px; padding-right: 15px;" class="stock-span">
                <?= $goods['stock'] <= 0 ? '已售罄' : '库存 ' . $goods['stock'] ?>
            </span>
                                <button class="drawer-btn buy-btn-g" id="drawerBuyNowBtn">
                                    立即购买
                                    <span class="total-price">¥<?= $goods['price'] ?></span>
                                </button>

                            </div>
                        </div>



                    </div>
                </div>
            </div>
        </div>
    </div>





    <div class="card" style="padding: 15px;">
        <div class="markdown intro" id="emlogEchoLog"><?= $goods['content'] ?></div>
    </div>





    <div style="clear:both;"></div>
</article>


<script>
    layui.use(['carousel', 'layer'], function() {
        var layer = layui.layer;
        // 规格选择
        var specOptions = document.querySelectorAll('.spec-option:not(.disabled)');
        specOptions.forEach(function(option) {
            option.addEventListener('click', function() {

                if (this.classList.contains('disabled')) {
                    return;
                }

                var parent = this.parentElement;
                // 判断当前选项是否已激活
                if (this.classList.contains('active')) {
                    // 已激活则直接取消
                    this.classList.remove('active');
                } else {
                    // 未激活则先移除同组其他选项的active，再给当前选项添加
                    parent.querySelectorAll('.spec-option').forEach(function(item) {
                        item.classList.remove('active');
                    });
                    this.classList.add('active');
                }
                // 无论选中还是取消，都重新计算价格库存
                getPirceStock();
            });
        });

        function getPirceStock(){
            var quantity = quantityInput.value;
            // 获取所有类同时包含 spec-option 和 active 的元素
            var $activeOptions = $('.spec-option.active');
            var activeDataIds = [];
            $activeOptions.each(function() {
                activeDataIds.push($(this).data('id'));
            });
            console.log(activeDataIds)
            var loadIndex = layer.load(2);
            $.ajax({
                url: '<?= EM_URL ?>user/shop.php?action=goods_price_stock',
                type: 'POST',
                data: {
                    goods_id: <?= $goods['id'] ?>,
                    quantity: quantity,
                    sku_ids: activeDataIds,
                },
                dataType: 'json',
                timeout: 2000, // 超时时间（毫秒）
                beforeSend: function(xhr) {
                    // 请求发送前的处理（如设置请求头）
                },
                success: function(e) {
                    if(e.data.is_select_sku == 'y'){
                        if(e.data.discount > 0){
                            $('.total-price').html('&yen;' + e.data.price + '&nbsp;&nbsp;<span style="font-size: 13px;">已优惠：' + e.data.discount + '</span>');
                        }else{
                            $('.total-price').html('&yen;' + e.data.price);
                        }
                    }else{
                        $('.total-price').html('&yen;' + <?= $goods['price'] ?>);
                    }


                    if(e.data.stock > 0){
                        $('.stock-span').html('库存 ' + e.data.stock)
                    }else{
                        $('.stock-span').html('已售罄')
                    }

                    // 1. 先禁用所有规格项
                    $('.spec-option').addClass('disabled');

                    // 2. 标记已选规格为“选中”状态（不禁用）
                    Object.values(activeDataIds).forEach(specId => {
                        $(`.spec-option[data-id="${specId}"]`).removeClass('disabled');
                    });


                    // 3. 过滤有效SKU：包含所有已选规格且有库存
                    const validSkus = e.data.skus.filter(sku => {
                        if (sku.stock <= 0) return false; // 排除无库存的SKU
                        const skuSpecIds = sku.sku.split('-').map(Number);
                        // 检查当前SKU是否包含所有已选规格
                        return Object.values(activeDataIds).every(selectedId => skuSpecIds.includes(selectedId));
                    });

                    // 4. 提取有效SKU中所有规格ID（用于启用对应规格项）
                    const availableSpecIds = new Set();
                    validSkus.forEach(sku => {
                        sku.sku.split('-').map(Number).forEach(id => availableSpecIds.add(id));
                    });



                    // 5. 启用有效规格项（排除已选组内的其他项，避免同组多选）
                    $('.spec-option').each(function() {
                        const $this = $(this);
                        const specId = $this.data('id');
                        const specGroupId = $this.data('group-id'); // 假设规格项有“所属组ID”属性
                        console.log(specGroupId)
                        // 规则：如果规格项在有效ID中，且不属于已选的组（同组只能选一个），则启用
                        if (availableSpecIds.has(specId) && !activeDataIds[specGroupId]) {
                            $this.removeClass('disabled');
                        }
                    });


                },
                error: function(xhr, status, error) {
                    // 请求失败的回调（超时、网络错误、服务器错误等）
                    if(error == 'timeout'){
                        layer.msg('请求超时，请重试');
                    }else{
                        layer.msg('请求失败：' + error);
                    }

                },
                complete: function(xhr, status) {
                    // 请求完成的回调（无论成功/失败都会执行）
                    layer.close(loadIndex);
                }
            });
        }

        // 抽屉内数量选择
        var minusBtn = document.getElementById('drawerMinusBtn');
        var plusBtn = document.getElementById('drawerPlusBtn');
        var quantityInput = document.getElementById('drawerQuantityInput');

        minusBtn.addEventListener('click', function() {
            var quantity = parseInt(quantityInput.value);
            if (quantity > 1) {
                quantityInput.value = quantity - 1;
                getPirceStock();
            }
        });

        plusBtn.addEventListener('click', function() {
            var quantity = parseInt(quantityInput.value);
            quantityInput.value = quantity + 1;
            getPirceStock();
        });

        quantityInput.addEventListener('change', function() {
            var quantity = parseInt(this.value);
            if (isNaN(quantity) || quantity < 1) {
                this.value = 1;
            }
            getPirceStock();
        });




        // 抽屉内立即购买按钮
        document.getElementById('drawerBuyNowBtn').addEventListener('click', function() {
            var quantity = quantityInput.value;
            // closeDrawerFunc();
            // 获取所有类同时包含 spec-option 和 active 的元素
            var $activeOptions = $('.spec-option.active');
            var activeDataIds = [];
            $activeOptions.each(function() {
                activeDataIds.push($(this).data('id'));
            });
            var payment_plugin = $('.payment-item.active').data('method');
            var payment_title = $('.payment-item.active .payment-name').text();

            const attach = {};
            $('.attach-input').each(function() {
                const $input = $(this);
                const value = $input.val().trim(); // 获取当前输入框的值
                const name = $input.attr('name'); // 获取 name 属性，如 "attach[手机号]"

                // 3. 解析 name 中的 key（如从 "attach[手机号]" 中提取 "手机号"）
                const key = name.match(/attach\[(.+?)\]/)[1];

                // 4. 存入对象（键为解析出的 key，值为输入框的值）
                attach[key] = value;
            });

            const required = {};
            $('.required-input').each(function() {
                const $input = $(this);
                const value = $input.val().trim(); // 获取当前输入框的值
                const name = $input.attr('name'); // 获取 name 属性，如 "required[手机号]"

                // 3. 解析 name 中的 key（如从 "attach[手机号]" 中提取 "手机号"）
                const key = name.match(/required\[(.+?)\]/)[1];

                // 4. 存入对象（键为解析出的 key，值为输入框的值）
                required[key] = value;
            });



            console.log('商品规格：' + activeDataIds);
            console.log('购买数量：' + quantity);
            console.log('支付插件：' + payment_plugin);
            console.log('支付名称：' + payment_title);
            console.log('附件内容：' + attach);
            console.log('必填项：' + required);


            // 开始下单
            let loadIndex = layer.load(2);
            $.ajax({
                url: '<?= EM_URL ?>/user/shop.php?action=xiadan',
                type: 'POST',
                data: {
                    goods_id: <?= $goods['id'] ?>,
                    quantity: quantity,
                    sku_ids: activeDataIds,
                    payment_plugin: payment_plugin,
                    payment_title: payment_title,
                    attach: attach,
                    required: required
                },
                dataType: 'json',
                timeout: 2000, // 超时时间（毫秒）
                beforeSend: function(xhr) {
                    // 请求发送前的处理（如设置请求头）
                },
                success: function(e) {
                    if(e.code == 400){
                        layer.msg(e.msg);
                    }
                    if(e.code == 200){
                        layer.msg('正在跳转支付页面');
                        window.open("<?= EM_URL ?>/?action=pay&out_trade_no=" + e.data.out_trade_no)
                    }
                },
                error: function(xhr, status, error) {
                    // 请求失败的回调（超时、网络错误、服务器错误等）
                    if(error == 'timeout'){
                        layer.msg('请求超时，请重试');
                    }else{
                        layer.msg('请求失败：' + error);
                    }

                },
                complete: function(xhr, status) {
                    // 请求完成的回调（无论成功/失败都会执行）
                    console.log('请求完成');
                    layer.close(loadIndex);
                }
            });
        });

        // 支付方式选择
        var $paymentItems = $('.payment-item');
        $paymentItems.click(function() {
            // 移除其他选中状态
            $paymentItems.removeClass('active');
            // 添加当前选中状态
            $(this).addClass('active');
        });

        // 默认选中第一个
        $paymentItems.eq(0).addClass('active');

    })
</script>

<?php include View::getCommonView('footer') ?>
