<?php defined('EM_ROOT') || exit('access denied!'); ?>

<div class="layui-tabs" style="margin-bottom: 12px;" lay-options="{trigger: false}">
    <ul class="layui-tabs-header">
        <li>
            <a href="./store.php?action=plu&plugin_type=0&title=全部插件"><i class="fa fa-one fa-shopping-cart"></i> 应用商店</a>
        </li>
        <li class="<?= $filter == '' ? 'layui-this' : '' ?>"><a href="./plugin.php">已安装</a></li>
        <li class="<?= $filter == 'on' ? 'layui-this' : '' ?>"><a href="./plugin.php?filter=on">启用中</a></li>
        <li class="<?= $filter == 'off' ? 'layui-this' : '' ?>"><a href="./plugin.php?filter=off">已关闭</a></li>
    </ul>
</div>
<table class="layui-hide" id="index" lay-filter="index"></table>
<script type="text/html" id="toolbar">
    <div class="layui-btn-container">
        <button class="layui-btn layui-btn-sm" lay-event="refresh">
            刷新
        </button>
    </div>
</script>
<script type="text/html" id="switch">
    <input type="checkbox" name="{{= d.alias }}" value="{{= d.active }}" title=" ON |OFF " lay-skin="switch" lay-filter="switch" {{= d.active == 1 ? "checked" : "" }}>
</script>

<script type="text/html" id="cover">
    <div class="layui-clear-space">
        <a href="javascript:;" data-id="{{ d.id }}" lay-event="img">
            <img onerror="this.onerror=null; this.src='./views/images/null.png'" class="cover" data-img="{{ d.preview }}" src="{{ d.preview }}" style="width: 50px; border-radius: 3px;" />
        </a>
    </div>
</script>

<script type="text/html" id="name">
    <div class="layui-clear-space">
        <div><strong>{{ d.Name }}</strong></div>
        <div>{{ d.Description }}</div>
    </div>
</script>
<script type="text/html" id="operate">
    <div class="layui-clear-space">
        <!--        $type = $v['type'] === 'template' ? 'tpl' : 'plugin';-->
        <!--        $order_url = SERVICE_HOST . '/index/order/submit/' . $type . '/' . $v['id'];-->
        {{#  if(d.Setting == true){ }}
        <button class="layui-btn layui-bg-blue" lay-event="setting">配置</button>
        {{#  } }}
        <button class="layui-btn layui-bg-red" lay-event="del">卸载</button>
        {{#  if(d.update == 1){ }}
        <button class="layui-btn layui-bg-green" lay-event="update">更新</button>
        {{#  } }}

    </div>
</script>


<script>
    layui.use(['table'], function(){
        var table = layui.table;
        var form = layui.form;
        var dropdown = layui.dropdown;


        // 创建渲染实例
        window.table = table.render({
            elem: '#index',
            autoSort: false,
            url: './plugin.php?action=index&filter=<?= $filter ?>', // 此处为静态模拟数据，实际使用时需换成真实接口
            // limits: [10,20,30,50,100],
            limits: [10],
            lineStyle: 'height: 69px;',
            page: false,
            cols: [[
                {field:'preview', title:'演示图', width: 80, templet: '#cover', align: 'center'},
                {field:'name', title:'插件名', minWidth: 520, templet: '#name'},
                {field:'active', title:'开关', width: 100, templet: '#switch'},
                {field:'Author', title:'作者', width: 100},
                {field:'Version', title:'版本', width: 100},
                {title:'操作', templet: '#operate', width: 250}
            ]],

            error: function(res, msg){
                console.log(res, msg)
            }
        });

        // 搜索提交
        form.on('submit(index-search)', function(data){
            var field = data.field; // 获得表单字段
            // 执行搜索重载
            table.reload('index', {
                page: {
                    curr: 1 // 重新从第 1 页开始
                },
                where: field // 搜索的字段
            });
            return false; // 阻止默认 form 跳转
        });

        // 状态 - 开关操作
        form.on('switch(switch)', function(obj){
            var active = obj.elem.checked == true ? 1 : 0;
            var alias = this.name;
            console.log('active: ' + active)
            console.log('alias: ' + alias)
            var loadSwitch = layer.load(2);
            $.ajax({
                url: '?action=switch',
                type: 'POST',
                dataType: 'json',
                data: { plugin: alias, status: active, token: '<?= LoginAuth::genToken() ?>' },
                success: function(res) {
                    layer.msg('操作成功');
                },
                error: function(err) {
                    layer.msg(err.responseJSON.msg);
                },
                complete: function() {
                    layer.close(loadSwitch);
                }
            });
        });


        // 工具栏事件
        table.on('toolbar(index)', function(obj){
            var id = obj.config.id;
            var checkStatus = table.checkStatus(id);
            var othis = lay(this);
            if(obj.event == 'refresh'){
                table.reload(id);
            }

        });

        // 触发单元格工具事件
        table.on('tool(index)', function(obj){ // 双击 toolDouble
            var data = obj.data; // 获得当前行数据
            var id = obj.config.id;
            if(obj.event == 'del'){
                layer.confirm('删除该插件？', {
                    btn: ['删除插件', '取消'], // 按钮
                    icon: 3,             // 图标，3表示问号
                    title: '温馨提示'
                }, function(index) {
                    var loadSwitch = layer.load(2);
                    $.ajax({
                        url: '?action=del',
                        type: 'POST',
                        dataType: 'json',
                        data: { plugin: data.alias, token: '<?= LoginAuth::genToken() ?>' },
                        success: function(e) {
                            layer.msg('删除成功');
                            table.reload(id);
                        },
                        error: function(err) {
                            layer.msg(err.responseJSON.msg);
                        },
                        complete: function() {
                            layer.close(loadSwitch);
                        }
                    });
                });
            }
            if(obj.event == 'update'){
                var loadSwitch = layer.load(2);
                $.ajax({
                    url: '?action=upgrade',
                    type: 'POST',
                    dataType: 'json',
                    data: { alias: data.Plugin, token: '<?= LoginAuth::genToken() ?>' },
                    success: function(e) {
                        layer.msg('更新成功');
                        table.reload(id);
                    },
                    error: function(err) {
                        layer.msg(err.responseJSON.msg);
                    },
                    complete: function() {
                        layer.close(loadSwitch);
                    }
                });
            }

            if(obj.event === 'setting'){
                if(data.Ui == 'Layui'){
                    let isMobile = window.innerWidth < 1200;
                    let area = isMobile ? ['98%', '85%']  : ['1000px', '80%'];
                    layer.open({
                        id: 'edit',
                        title: data.Name,
                        type: 2,
                        area: area,
                        // skin: 'layui-layer-win10',
                        skin: 'layui-layer-molv',
                        content: 'plugin.php?action=setting_page&plugin=' + data.Plugin,
                        fixed: false, // 不固定
                        maxmin: true,
                        shadeClose: true,
                        success: function(layero, index, that){
                            // layer.iframeAuto(index); // 让 iframe 高度自适应
                            // that.offset(); // 重新自适应弹层坐标
                        }
                    });
                }else{
                    location.href = "./plugin.php?plugin=" + data.Plugin;
                }

            }
            if(obj.event === 'img'){
                layer.photos({
                    photos: {
                        "title": data.Name,
                        "start": 0,
                        "data": [
                            {
                                "alt": data.Name,
                                "pid": 1,
                                "src": data.preview,
                            }
                        ]
                    }
                });
            }
        });



    });

</script>


<script>
    $(function () {
        $("#menu-plugin").addClass('active');
    });
</script>
