<?php
/**
 * Service: Api
 */

class Api {

    private static $resp = 'local';
    private static $post = [];

    private static function init(){
        self::$resp = 'api';
    }

    /**
     * 获取商品分类
     */
    public static function getSortAll() {

        $db = Database::getInstance();
        $db_prefix = DB_PREFIX;

        $sql = "select * from {$db_prefix}sort where type='goods' order by taxis desc, sid asc";

        $list = $db->fetch_all($sql);

        return self::ret($list);
    }

    /**
     * 获取商品列表
     * @post.sort_id 分类id，为空时获取全部商品
     * @post.keyword 商品搜索
     */
    public static function getGoodsList($post) {
        $db = Database::getInstance();
        $db_prefix = DB_PREFIX;
        $sort_id = $post['sort_id'];
        $keyword = $post['keyword'];
        $where = "";
        if(!empty($keyword)){
            $where .= " and g.title like '%{$keyword}%'";
        }

        if($sort_id != 0){
            $where .= " and g.sort_id={$sort_id}";
        }
        $sql = "SELECT 
            g.title, g.cover, g.des, g.type, g.id goods_id, g.des, g.sales, g.sort_id, g.id goods_id, 
            sku.guest_price, sku.user_price, g.stock stock_num, g.stock, 
            mp.member_level mp_level, mp.price mp_price
        FROM {$db_prefix}goods g
        LEFT JOIN {$db_prefix}skus sku ON sku.goods_id = g.id
        LEFT JOIN {$db_prefix}member_price mp ON mp.goods_id = g.id
        WHERE g.is_on_shelf = 1 AND g.delete_time IS NULL {$where}
        GROUP BY sku.sku, sku.goods_id, mp.member_level
        ORDER BY g.index_top DESC, g.sort_top DESC, g.sort_num DESC, g.id asc";

        $data = $db->fetch_all($sql);
        $goods = [];
        foreach($data as $val){

            if(isset($goods[$val['goods_id']])){
                $goods[$val['goods_id']]['mp'][$val['mp_level']] = $val['mp_price'];
            }else{
                $goods[$val['goods_id']] = $val;
                $goods[$val['goods_id']]['url'] = Url::goods($val['goods_id']);
                $goods[$val['goods_id']]['mp'][$val['mp_level']] = $val['mp_price'];
            }
        }
//        d($data);die;
        foreach($goods as $key => $val){
            if(LEVEL == -1){
                $goods[$key]['price'] = $val['guest_price'];
            }else if(LEVEL == 0){
                $goods[$key]['price'] = $val['user_price'];
            }else{
                if(!empty($val['mp'])){
                    foreach($val['mp'] as $k => $v){
                        if($k == LEVEL){
                            $goods[$key]['price'] = $v;
                        }
                    }
                    if(!isset($goods[$key]['price'])){
                        $goods[$key]['price'] = $val['user_price'];
                    }
                }else{
                    $goods[$key]['price'] = $val['user_price'];
                }
            }
            $goods[$key]['price'] = $goods[$key]['price'] / 100;
        }

        doMultiAction('goods_list', $goods, $goods);

        return self::ret($goods);
    }

    /**
     * 返回数据
     */
    private static function ret($data){
        if(self::$resp == 'api'){
            Ret::success('success', $data);
        }else{
            return $data;
        }
    }
}